<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\Lottery;

// lottery plugin root
define('__PATH_LOTTERY_ROOT__', __PATH_PLUGINS__.'lottery/');

// lottery plugin root
define('__LOTTERY_HOME__', __BASE_URL__.'lottery/');

// admincp
$extra_admincp_sidebar[] = array(
    'Lottery System', array(
        array('Settings','lottery&page=settings'),
        array('Status','lottery&page=status'),
        array('List','lottery&page=list'),
        array('Stash List','lottery&page=stash'),
    )
);

if(file_exists(__PATH_LOTTERY_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_LOTTERY_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading lottery language file.');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_LOTTERY_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading lottery language file.');
}

// load classes
if(!@include_once(__PATH_LOTTERY_ROOT__ . 'classes/class.lottery.php')) throw new Exception(lang('lottery_error_23', true));